﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;          // added to include serial ports
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Management;

namespace USB_RLY16_TEST
{
    public partial class Form1 : Form
    {

        static SerialPort USB_PORT;
        byte usb_opto_rly88_found = 0, usb_opto_rly816_found = 0;
        byte[] SerBuf = new byte[10];
        byte serial_written_flag = 0;

        public Form1()
        {
            InitializeComponent();
            USB_PORT = new SerialPort();
            string[] comportnames = new string[100];
            comportnames = SerialPort.GetPortNames();
            var sortedList = comportnames.OrderBy(port => Convert.ToInt32(port.Replace("COM", string.Empty)));
            foreach (string port in sortedList)
            {
                comboBox_comport.Items.Add(port);                      // places each "COMx" name into combobox
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (usb_opto_rly88_found == 1)
                {
                    if (serial_written_flag != 1) textBox_status.Text = "USB-OPTO-RLY88 found";
                    textBox_dcin.Visible = label3.Visible = false;
                }
                else
                {
                    if (serial_written_flag != 1) textBox_status.Text = "USB-OPTO-RLY816 found";
                    textBox_dcin.Visible = label3.Visible = true;
                    SerBuf[0] = 0x5D;       // get dc voltage command
                    transmit(1);
                    receive(1);
                    textBox_dcin.Text = string.Format("{0}v", (float)SerBuf[0] / 10);

                }
                SerBuf[0] = 0x19;       // get input states command
                transmit(1);
                receive(1);
                if ((SerBuf[0] & 0x01) == 0) radioButton1.Checked = false; else radioButton1.Checked = true;
                if ((SerBuf[0] & 0x02) == 0) radioButton2.Checked = false; else radioButton2.Checked = true;
                if ((SerBuf[0] & 0x04) == 0) radioButton3.Checked = false; else radioButton3.Checked = true;
                if ((SerBuf[0] & 0x08) == 0) radioButton4.Checked = false; else radioButton4.Checked = true;
                if ((SerBuf[0] & 0x10) == 0) radioButton5.Checked = false; else radioButton5.Checked = true;
                if ((SerBuf[0] & 0x20) == 0) radioButton6.Checked = false; else radioButton6.Checked = true;
                if ((SerBuf[0] & 0x40) == 0) radioButton7.Checked = false; else radioButton7.Checked = true;
                if ((SerBuf[0] & 0x80) == 0) radioButton8.Checked = false; else radioButton8.Checked = true;
 
 
                SerBuf[0] = 0x5B;       // get states command for RLY16
                transmit(1);
                receive(1);
                
                if ((SerBuf[0] & 0x01) == 0x01)
                {
                    button_relay1.Text = "RELAY 1 ON";
                    button_relay1.BackColor = Color.Red;
                }
                else
                {
                    button_relay1.Text = "RELAY 1 OFF";
                    button_relay1.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x02) == 0x02)
                {
                    button_relay2.Text = "RELAY 2 ON";
                    button_relay2.BackColor = Color.Red;
                }
                else
                {
                    button_relay2.Text = "RELAY 2 OFF";
                    button_relay2.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x04) == 0x04)
                {
                    button_relay3.Text = "RELAY 3 ON";
                    button_relay3.BackColor = Color.Red;
                }
                else
                {
                    button_relay3.Text = "RELAY 3 OFF";
                    button_relay3.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x08) == 0x08)
                {
                    button_relay4.Text = "RELAY 4 ON";
                    button_relay4.BackColor = Color.Red;
                }
                else
                {
                    button_relay4.Text = "RELAY 4 OFF";
                    button_relay4.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x10) == 0x10)
                {
                    button_relay5.Text = "RELAY 5 ON";
                    button_relay5.BackColor = Color.Red;
                }
                else
                {
                    button_relay5.Text = "RELAY 5 OFF";
                    button_relay5.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x20) == 0x20)
                {
                    button_relay6.Text = "RELAY 6 ON";
                    button_relay6.BackColor = Color.Red;
                }
                else
                {
                    button_relay6.Text = "RELAY 6 OFF";
                    button_relay6.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x40) == 0x40)
                {
                    button_relay7.Text = "RELAY 7 ON";
                    button_relay7.BackColor = Color.Red;
                }
                else
                {
                    button_relay7.Text = "RELAY 7 OFF";
                    button_relay7.BackColor = Color.White;
                }
                if ((SerBuf[0] & 0x80) == 0x80)
                {
                    button_relay8.Text = "RELAY 8 ON";
                    button_relay8.BackColor = Color.Red;
                }
                else
                {
                    button_relay8.Text = "RELAY 8 OFF";
                    button_relay8.BackColor = Color.White;
                }
            }
            else
            {
                textBox_status.Text = "Relay module not found";
                textBox_ver.Text = "";
                textBox_dcin.Text = "";
                button_relay1.Text = "RELAY 1";
                button_relay1.BackColor = Color.White;
                button_relay2.Text = "RELAY 2";
                button_relay2.BackColor = Color.White;
                button_relay3.Text = "RELAY 3";
                button_relay3.BackColor = Color.White;
                button_relay4.Text = "RELAY 4";
                button_relay4.BackColor = Color.White;
                button_relay5.Text = "RELAY 5";
                button_relay5.BackColor = Color.White;
                button_relay6.Text = "RELAY 6";
                button_relay6.BackColor = Color.White;
                button_relay7.Text = "RELAY 7";
                button_relay7.BackColor = Color.White;
                button_relay8.Text = "RELAY 8";
                button_relay8.BackColor = Color.White;
            }
        }

        private void comboBox_comport_SelectedIndexChanged(object sender, EventArgs e)
        {
            usb_opto_rly88_found = usb_opto_rly816_found = 0;

            if (comboBox_comport.Text.StartsWith("COM"))
            {
                if(USB_PORT.IsOpen) USB_PORT.Close();                            // close any existing handle
                USB_PORT.PortName = comboBox_comport.Text;    // retrieves "COMx" from selection in combo box
                USB_PORT.Parity = 0;
                USB_PORT.BaudRate = 19200;
                USB_PORT.StopBits = StopBits.Two;
                USB_PORT.DataBits = 8;
                USB_PORT.ReadTimeout = 50;
                USB_PORT.WriteTimeout = 50;
                USB_PORT.Open();

                SerBuf[0] = 0x5A;       // get version command for RLY16, returns module id and software version
                transmit(1);
                receive(2);

                if (SerBuf[0] == 12)  // if the module id is that of the usb-opto-rly88  
                {
                    textBox_ver.Text = string.Format("{0}", SerBuf[1]);  //print the software version on screen
                    usb_opto_rly88_found = 1;                            // and set the usb-i2c found indicator
                }
                else if (SerBuf[0] == 13)  // if the module id is that of the usb-opto-rly816  
                {
                    textBox_ver.Text = string.Format("{0}", SerBuf[1]);  //print the software version on screen
                    usb_opto_rly816_found = 1;                            // and set the usb-i2c found indicator
                }
            }
        }


        private void transmit(byte write_bytes)
        {
            if (comboBox_comport.Text.StartsWith("COM"))
            {
                try
                {
                    USB_PORT.Write(SerBuf, 0, write_bytes);      // writes specified amount of SerBuf out on COM port
                }
                catch (Exception)
                {
                    MessageBox.Show("write fail");
                }
            }
         }

        private void receive(byte read_bytes)
        {
            byte x;

            if (comboBox_comport.Text.StartsWith("COM"))
            {
                for (x = 0; x < read_bytes; x++)       // this will call the read function for the passed number times, 
                {                                      // this way it ensures each byte has been correctly recieved while
                    try                                // still using timeouts
                    {
                        USB_PORT.Read(SerBuf, x, 1);     // retrieves 1 byte at a time and places in SerBuf at position x
                    }
                    catch (Exception)                   // timeout or other error occured, set lost comms indicator
                    {
                        SerBuf[0] = 255;
                        MessageBox.Show("read fail");
                        usb_opto_rly88_found = usb_opto_rly816_found = 0;
                    }
                }
            }
         }

        private void button_relay1_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay1.Text == "RELAY 1 ON") SerBuf[0] = 0x6F;
                else SerBuf[0] = 0x65;
                transmit(1);
            }
        }

        private void button_relay2_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay2.Text == "RELAY 2 ON") SerBuf[0] = 0x70;
                else SerBuf[0] = 0x66;
                transmit(1);
            }
        }

        private void button_relay3_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay3.Text == "RELAY 3 ON") SerBuf[0] = 0x71;
                else SerBuf[0] = 0x67;
                transmit(1);
            }
        }

        private void button_relay4_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay4.Text == "RELAY 4 ON") SerBuf[0] = 0x72;
                else SerBuf[0] = 0x68;
                transmit(1);
            }
        }

        private void button_relay5_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay5.Text == "RELAY 5 ON") SerBuf[0] = 0x73;
                else SerBuf[0] = 0x69;
                transmit(1);
            }
        }

        private void button_relay6_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay6.Text == "RELAY 6 ON") SerBuf[0] = 0x74;
                else SerBuf[0] = 0x6A;
                transmit(1);
            }
        }

        private void button_relay7_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay7.Text == "RELAY 7 ON") SerBuf[0] = 0x75;
                else SerBuf[0] = 0x6B;
                transmit(1);
            }
        }

        private void button_relay8_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                if (button_relay8.Text == "RELAY 8 ON") SerBuf[0] = 0x76;
                else SerBuf[0] = 0x6C;
                transmit(1);
            }
        }

        private void button_allon_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                SerBuf[0] = 0x64;
                transmit(1);
            }
        }

        private void button_alloff_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                SerBuf[0] = 0x6E;
                transmit(1);
            }
        }

        private void button_01010101_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                SerBuf[0] = 0x5C;
                SerBuf[1] = 0x55;
                transmit(2);
            }
        }

        private void button10101010_Click(object sender, EventArgs e)
        {
            if (usb_opto_rly88_found == 1 || usb_opto_rly816_found == 1)
            {
                SerBuf[0] = 0x5c;
                SerBuf[1] = 0xAA;
                transmit(2);
            }
        }

    }
}
